class Tower_Krall extends Tower;

var() byte StrikeDamage,
	ThrowDamage,
	PoundDamage;
var bool AttackSuccess;
var() bool bSpearToss;
var() bool bDicePlayer;
var() bool bSleeping;
var   bool bHasDice;
var	  bool bHeldDice;
var(Sounds) sound strike1;
var(Sounds) sound strike2;
var(Sounds) sound twirl;
var(Sounds) sound syllable1;
var(Sounds) sound syllable2;
var(Sounds) sound syllable3;
var(Sounds) sound syllable4;
var(Sounds) sound syllable5;
var(Sounds) sound syllable6;
var(Sounds) sound die2;
var(Sounds)	sound spearHit;
var(Sounds) sound spearThrow;
var 	name phrase;
var		byte phrasesyllable;
var		float	voicePitch;
var Dice Toy1;
var Dice Toy2;
var()	float MinDuckTime;
var		float LastDuckTime;
var Pawn Target2;

simulated function Tick(float DT) 
{
	Super.Tick(DT);
	
}

state TacticalMove
{
ignores SeePlayer, HearNoise;

	function FireAtEnemy()
	{
	local Pawn P;
	local float ClosestOne,ClosestTwo;
	local Pawn Target;
	local float Range;
	local PBPRI PRI;
	
	PRI = PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo);
	
	if ( PRI.KrallLevel == 0 )
		Range = 250;
	else if ( PRI.KrallLevel >= 1 )
		Range = 350;
	
	Target = None;
	Target2 = None;
	
	for ( P=Level.PawnList; P!=None; P=P.nextPawn )
		{
		if ( P.IsA('Balloon') )
			{
			if ( Balloon(P).bCamo && !PBPRI(TowerOwner.PlayerReplicationInfo).bHasCamoDetection)
				{
				//Player doesn't have camo detection na na na naaaaa naaaa :-P
				}
			else
				{
				if ( Vsize(P.Location - Location) < Range )
					{
					if ( Vsize(P.Location - Location) < ClosestOne || ClosestOne == 0 )
						{
						ClosestOne = Vsize(P.Location - Location);
						if ( Target != None )
							Target2 = Target;
						Target = P;
						}
					}
				}
			}
		}
	if ( Target != None )
		{
		Shoot(Target);
		Enemy = Target;
		MyTarget = Target;
		}
	else
		MyTarget = None;
	}

	function Shoot(Pawn Target)
	{
	local Vector FireSpot, ProjStart;
	local Proj_Tower_Krall p,p2;
	local Rotator FireRotation;
	
	PlaySound(FireSound, SLOT_None,5.0);

	ProjStart = Location;
	FireSpot = Target.Location + FMin(1, 0.7 + 0.6 * FRand()) * (Target.Velocity * VSize(Target.Location - ProjStart)/ProjectileType.Default.Speed);
	if ( !FastTrace(FireSpot, ProjStart) )
			FireSpot = 0.5 * (FireSpot + Target.Location);
	FireRotation = Rotator(Target.Location - Location);
	p = Spawn (Class'Proj_Tower_Krall',TowerOwner,,ProjStart,FireRotation);
	P.Velocity *= 10;
	p.instigator = TowerOwner;
	p.Tower = Self;
	PlayAnim('Shoot1');
	
	if ( PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo).KrallLevel >= 2 && Target2 != None)
		{
		FireSpot = Target2.Location + FMin(1, 0.7 + 0.6 * FRand()) * (Target2.Velocity * VSize(Target.Location - ProjStart)/ProjectileType.Default.Speed);
		if ( !FastTrace(FireSpot, ProjStart) )
			FireSpot = 0.5 * (FireSpot + Target2.Location);
		FireRotation = Rotator(Target2.Location - Location);
		p2 = Spawn (Class'Proj_Tower_Krall',TowerOwner,,ProjStart,FireRotation);
		P2.Velocity *= 10;
		p2.instigator = TowerOwner;
		p.Tower = Self;
		}
	}
}

defaultproperties
{
	 TowerName="Krall Tower"
	 ProjectileType=Class'Proj_Tower_Krall'
	 FireSound=Sound'UnrealI.Cannon.CannonShot'
	 TimerSpeed(1)=1.2
	 TimerSpeed(2)=1.2
	 TimerSpeed(3)=1.2
	 TimerSpeed(4)=1.2
     Acquire=Sound'UnrealI.Krall.chlng1k'
     Fear=Sound'UnrealI.Krall.chlng2k'
     Threaten=Sound'UnrealI.Krall.chlng2k'
     MeleeRange=50.000000
     GroundSpeed=0.000000
     AirSpeed=0.000000
     AccelRate=50.000000
     JumpZ=0.000000
     HearingThreshold=0.000000
     Health=180
     Intelligence=BRAINS_HUMAN
     HitSound1=Sound'UnrealI.Krall.injur1k'
     HitSound2=Sound'UnrealI.Krall.injur2k'
     Die=Sound'UnrealI.Krall.death1k'
     CombatStyle=0.800000
     AmbientSound=Sound'UnrealI.Krall.amb1kr'
     DrawType=DT_Mesh
     Mesh=LodMesh'UnrealI.KrallM'
     TransientSoundVolume=1.500000
     CollisionRadius=25.000000
     CollisionHeight=46.000000
     Mass=140.000000
     Buoyancy=140.000000
     RotationRate=(Pitch=3072,Yaw=60000,Roll=0)
	 DrawScale=0.6
}
